/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.container;

import com.nyfaria.numismaticoverhaul.owostuff.ui.base.BaseParentComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Insets;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ModComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ParentComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Size;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Sizing;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIModel;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIModelParsingException;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIParsing;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public abstract class WrappingParentComponent<C extends ModComponent>
extends BaseParentComponent {
    protected C child;
    protected List<ModComponent> childView;

    protected WrappingParentComponent(Sizing horizontalSizing, Sizing verticalSizing, C child) {
        super(horizontalSizing, verticalSizing);
        this.child = child;
        this.childView = Collections.singletonList(this.child);
    }

    @Override
    protected void applyHorizontalContentSizing(Sizing sizing) {
        this.width = this.child.fullSize().width() + ((Insets)this.padding.get()).horizontal();
    }

    @Override
    protected void applyVerticalContentSizing(Sizing sizing) {
        this.height = this.child.fullSize().height() + ((Insets)this.padding.get()).vertical();
    }

    @Override
    public void layout(Size space) {
        this.child.inflate(this.calculateChildSpace(space));
        this.child.mount(this, this.childMountX(), this.childMountY());
    }

    protected int childMountX() {
        return this.x + ((Insets)this.child.margins().get()).left() + ((Insets)this.padding.get()).left();
    }

    protected int childMountY() {
        return this.y + ((Insets)this.child.margins().get()).top() + ((Insets)this.padding.get()).top();
    }

    public WrappingParentComponent<C> child(C newChild) {
        if (this.child != null) {
            this.child.dismount(ModComponent.DismountReason.REMOVED);
        }
        this.child = newChild;
        this.childView = Collections.singletonList(this.child);
        this.updateLayout();
        return this;
    }

    public C child() {
        return this.child;
    }

    @Override
    public List<ModComponent> children() {
        return this.childView;
    }

    @Override
    public ParentComponent removeChild(ModComponent child) {
        throw new UnsupportedOperationException("Cannot remove the child of a wrapping component");
    }

    @Override
    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        try {
            List childList = UIParsing.allChildrenOfType(element, (short)1);
            this.child(model.parseComponent(ModComponent.class, (Element)childList.get(0)));
        }
        catch (UIModelParsingException exception) {
            throw new UIModelParsingException("Could not initialize container child", exception);
        }
    }
}

